/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.datagen;

import java.util.HashMap;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.hibiscus.naturespirit.registration.NSColoredBlocks;
import net.hibiscus.naturespirit.registration.NSMiscBlocks;
import net.hibiscus.naturespirit.registration.NSRegistryHelper;
import net.hibiscus.naturespirit.registration.NSWoods;
import net.hibiscus.naturespirit.registration.sets.FlowerSet;
import net.hibiscus.naturespirit.registration.sets.StoneSet;
import net.hibiscus.naturespirit.registration.sets.WoodSet;
import net.minecraft.class_116;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_192;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3489;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_7788;
import net.minecraft.class_79;
import net.minecraft.class_8169;
import net.minecraft.class_85;
import net.minecraft.class_94;

class NSBlockLootTableProvider
extends FabricBlockLootTableProvider {
    private final float[] SAPLING_DROP_CHANCE_2 = new float[]{0.4f, 0.45333335f, 0.625f, 0.758f};
    private static final float[] LEAVES_STICK_DROP_CHANCE = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    protected NSBlockLootTableProvider(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    private void addWoodTable(HashMap<String, WoodSet> woods) {
        for (WoodSet woodSet : woods.values()) {
            if (woodSet.hasBark()) {
                this.method_46025(woodSet.getWood());
                this.method_46025(woodSet.getStrippedWood());
            }
            if (woodSet.hasMosaic()) {
                this.method_46025(woodSet.getMosaic());
                this.method_46025(woodSet.getMosaicStairs());
                this.method_45994(woodSet.getMosaicSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
            }
            if (woodSet.getWoodPreset() == WoodSet.WoodPreset.JOSHUA) {
                this.method_46025(woodSet.getBundle());
                this.method_46025(woodSet.getStrippedBundle());
            }
            this.method_46025(woodSet.getLog());
            this.method_46025(woodSet.getStrippedLog());
            this.method_46025(woodSet.getPlanks());
            this.method_46025(woodSet.getButton());
            this.method_45994(woodSet.getDoor(), arg_0 -> ((NSBlockLootTableProvider)this).method_46022(arg_0));
            this.method_46025(woodSet.getStairs());
            this.method_45994(woodSet.getSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(woodSet.getFence());
            this.method_46025(woodSet.getTrapDoor());
            this.method_46025(woodSet.getSign());
            this.method_46025(woodSet.getHangingSign());
            this.method_46025(woodSet.getPressurePlate());
            this.method_46025(woodSet.getFenceGate());
        }
    }

    private void addStoneTable(HashMap<String, StoneSet> stones) {
        for (StoneSet stoneSet : stones.values()) {
            if (stoneSet.hasTiles()) {
                this.method_46025(stoneSet.getTiles());
                this.method_46025(stoneSet.getTilesStairs());
                this.method_45994(stoneSet.getTilesSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getTilesWall());
                if (stoneSet.hasCracked()) {
                    this.method_46025(stoneSet.getCrackedTiles());
                }
            }
            if (stoneSet.hasMossy()) {
                this.method_46025(stoneSet.getMossyBricks());
                this.method_46025(stoneSet.getMossyBricksStairs());
                this.method_45994(stoneSet.getMossyBricksSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getMossyBricksWall());
            }
            if (stoneSet.hasCracked()) {
                this.method_46025(stoneSet.getCrackedBricks());
            }
            if (stoneSet.hasCobbled()) {
                this.method_46025(stoneSet.getCobbled());
                this.method_46025(stoneSet.getCobbledStairs());
                this.method_45994(stoneSet.getCobbledSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
                this.method_46025(stoneSet.getCobbledWall());
                this.method_45994(stoneSet.getBase(), block -> this.method_45983((class_2248)block, (class_1935)stoneSet.getCobbled()));
                if (stoneSet.hasMossy()) {
                    this.method_46025(stoneSet.getMossyCobbled());
                    this.method_46025(stoneSet.getMossyCobbledStairs());
                    this.method_45994(stoneSet.getMossyCobbledSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
                    this.method_46025(stoneSet.getMossyCobbledWall());
                }
            } else {
                this.method_46025(stoneSet.getBase());
            }
            this.method_46025(stoneSet.getBaseStairs());
            this.method_45994(stoneSet.getBaseSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getBricks());
            this.method_46025(stoneSet.getBricksStairs());
            this.method_45994(stoneSet.getBricksSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getBricksWall());
            this.method_46025(stoneSet.getPolished());
            this.method_46025(stoneSet.getPolishedStairs());
            this.method_45994(stoneSet.getPolishedSlab(), arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
            this.method_46025(stoneSet.getPolishedWall());
        }
    }

    private void addFlowerTable(HashMap<String, FlowerSet> flowers) {
        for (FlowerSet flowerSet : flowers.values()) {
            if (flowerSet.isTall()) {
                this.method_45994(flowerSet.getFlowerBlock(), block -> this.method_45987((class_2248)block, (class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607));
                continue;
            }
            this.method_46025(flowerSet.getFlowerBlock());
            this.method_46023(flowerSet.getPottedFlowerBlock());
        }
    }

    public class_52.class_53 noSaplingLeavesDrop(class_2248 leaves) {
        class_1792 drop = class_1802.field_8600;
        return NSBlockLootTableProvider.method_46008((class_2248)leaves, (class_79.class_80)((class_85.class_86)this.method_45978((class_1935)leaves, (class_192)class_77.method_411((class_1935)drop))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])field_40605))).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(field_40607).method_351(((class_85.class_86)this.method_45977((class_1935)leaves, (class_116)class_77.method_411((class_1935)class_1802.field_8600).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)2.0f))))).method_421(class_182.method_800((class_1887)class_1893.field_9130, (float[])LEAVES_STICK_DROP_CHANCE))));
    }

    public class_52.class_53 flowerbedDropsWithShears(class_2248 flowerbed) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)this.method_45977((class_1935)flowerbed, class_77.method_411((class_1935)flowerbed).method_43739(IntStream.rangeClosed(1, 4).boxed().toList(), flowerAmount -> class_141.method_621((class_5658)class_44.method_32448((float)flowerAmount.intValue())).method_524((class_5341.class_210)class_212.method_900((class_2248)flowerbed).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_8169.field_42765, flowerAmount.intValue()))).method_524(field_40606)))));
    }

    private void addTreeTable(HashMap<String, class_2248[]> saplings, HashMap<String, class_2248> leaves) {
        for (String i : leaves.keySet()) {
            class_2248 leavesType = leaves.get(i);
            if (saplings.get(i) != null) {
                class_2248[] saplingType = saplings.get(i);
                this.method_46025(saplingType[0]);
                this.method_46023(saplingType[1]);
                if (i.equals("joshua")) {
                    this.method_45994(leavesType, block -> this.method_45986((class_2248)block, saplingType[0], this.SAPLING_DROP_CHANCE_2));
                    continue;
                }
                this.method_45994(leavesType, block -> this.method_45986((class_2248)block, saplingType[0], field_40605));
                continue;
            }
            if (i.equals("yellow_aspen")) {
                this.method_45994(leavesType, block -> this.method_45986((class_2248)block, NSWoods.ASPEN.getSapling(), field_40605));
                continue;
            }
            this.method_45994(leavesType, this::noSaplingLeavesDrop);
        }
    }

    public void method_10379() {
        this.addFlowerTable(NSRegistryHelper.FlowerHashMap);
        this.addStoneTable(NSRegistryHelper.StoneHashMap);
        this.addWoodTable(NSRegistryHelper.WoodHashMap);
        this.addTreeTable(NSRegistryHelper.SaplingHashMap, NSRegistryHelper.LeavesHashMap);
        this.method_45994(NSWoods.OLIVE_BRANCH, class_7788::method_45995);
        this.method_45994(NSMiscBlocks.CALCITE_CLUSTER, block -> NSBlockLootTableProvider.method_45989((class_2248)block, (class_79.class_80)((class_85.class_86)class_77.method_411((class_1935)NSMiscBlocks.CALCITE_SHARD).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)4.0f))).method_438((class_117.class_118)class_94.method_455((class_1887)class_1893.field_9130)).method_421(class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8975(class_3489.field_29544)))).method_417((class_79.class_80)this.method_45977((class_1935)block, (class_116)class_77.method_411((class_1935)NSMiscBlocks.CALCITE_SHARD).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)))))));
        this.method_46024(NSMiscBlocks.SMALL_CALCITE_BUD);
        this.method_46024(NSMiscBlocks.LARGE_CALCITE_BUD);
        this.method_45994(NSMiscBlocks.CATTAIL, block -> this.method_45987((class_2248)block, (class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607));
        this.method_45999(NSWoods.WISTERIA.getWhiteVines(), NSWoods.WISTERIA.getWhiteVinesPlant());
        this.method_45999(NSWoods.WISTERIA.getBlueVines(), NSWoods.WISTERIA.getBlueVinesPlant());
        this.method_45999(NSWoods.WISTERIA.getPurpleVines(), NSWoods.WISTERIA.getPurpleVinesPlant());
        this.method_45999(NSWoods.WISTERIA.getPinkVines(), NSWoods.WISTERIA.getPinkVinesPlant());
        this.method_45999(NSWoods.WILLOW.getVines(), NSWoods.WILLOW.getVinesPlant());
        this.method_45988(NSWoods.FIR.getFrostyLeaves(), this.method_45986(NSWoods.FIR.getFrostyLeaves(), NSWoods.FIR.getSapling(), field_40605));
        this.method_45988(NSWoods.REDWOOD.getFrostyLeaves(), this.method_45986(NSWoods.REDWOOD.getFrostyLeaves(), NSWoods.REDWOOD.getSapling(), field_40605));
        this.method_46025(NSMiscBlocks.ALLUAUDIA);
        this.method_46025(NSMiscBlocks.ALLUAUDIA_BUNDLE);
        this.method_46025(NSMiscBlocks.STRIPPED_ALLUAUDIA);
        this.method_46025(NSMiscBlocks.STRIPPED_ALLUAUDIA_BUNDLE);
        this.method_45994(NSMiscBlocks.AZOLLA, this::flowerbedDropsWithShears);
        this.method_45994(NSMiscBlocks.CHERT_COAL_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8713));
        this.method_45994(NSMiscBlocks.CHERT_EMERALD_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8687));
        this.method_45994(NSMiscBlocks.CHERT_DIAMOND_ORE, block -> this.method_45981((class_2248)block, class_1802.field_8477));
        this.method_45994(NSMiscBlocks.CHERT_COPPER_ORE, arg_0 -> ((NSBlockLootTableProvider)this).method_46010(arg_0));
        this.method_45994(NSMiscBlocks.CHERT_REDSTONE_ORE, arg_0 -> ((NSBlockLootTableProvider)this).method_46012(arg_0));
        this.method_45994(NSMiscBlocks.CHERT_IRON_ORE, block -> this.method_45981((class_2248)block, class_1802.field_33400));
        this.method_45994(NSMiscBlocks.CHERT_GOLD_ORE, block -> this.method_45981((class_2248)block, class_1802.field_33402));
        this.method_45994(NSMiscBlocks.CHERT_LAPIS_ORE, arg_0 -> ((NSBlockLootTableProvider)this).method_46011(arg_0));
        this.method_46025(NSMiscBlocks.SHIITAKE_MUSHROOM);
        this.method_45988(NSMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, this.method_45998(NSMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, (class_1935)NSMiscBlocks.SHIITAKE_MUSHROOM));
        this.method_46025(NSMiscBlocks.GRAY_POLYPORE);
        this.method_45988(NSMiscBlocks.GRAY_POLYPORE_BLOCK, this.method_45998(NSMiscBlocks.GRAY_POLYPORE_BLOCK, (class_1935)NSMiscBlocks.GRAY_POLYPORE));
        this.method_45999(NSMiscBlocks.LOTUS_STEM, NSMiscBlocks.LOTUS_STEM);
        this.method_46006(NSMiscBlocks.LOTUS_FLOWER, (class_1935)NSMiscBlocks.LOTUS_FLOWER_ITEM);
        this.method_46025(NSMiscBlocks.SHIITAKE_MUSHROOM);
        this.method_45998(NSMiscBlocks.SHIITAKE_MUSHROOM_BLOCK, (class_1935)NSMiscBlocks.SHIITAKE_MUSHROOM);
        this.method_46025(NSWoods.COCONUT_THATCH);
        this.method_46025(NSWoods.COCONUT_THATCH_CARPET);
        this.method_46025(NSWoods.COCONUT_THATCH_STAIRS);
        this.method_45994(NSWoods.COCONUT_THATCH_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSWoods.EVERGREEN_THATCH);
        this.method_46025(NSWoods.EVERGREEN_THATCH_CARPET);
        this.method_46025(NSWoods.EVERGREEN_THATCH_STAIRS);
        this.method_45994(NSWoods.EVERGREEN_THATCH_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSWoods.XERIC_THATCH);
        this.method_46025(NSWoods.XERIC_THATCH_CARPET);
        this.method_46025(NSWoods.XERIC_THATCH_STAIRS);
        this.method_45994(NSWoods.XERIC_THATCH_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSMiscBlocks.PAPER_DOOR, arg_0 -> ((NSBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(NSMiscBlocks.PAPER_TRAPDOOR);
        this.method_45994(NSMiscBlocks.FRAMED_PAPER_DOOR, arg_0 -> ((NSBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(NSMiscBlocks.FRAMED_PAPER_TRAPDOOR);
        this.method_45994(NSMiscBlocks.BLOOMING_PAPER_DOOR, arg_0 -> ((NSBlockLootTableProvider)this).method_46022(arg_0));
        this.method_46025(NSMiscBlocks.BLOOMING_PAPER_TRAPDOOR);
        this.method_46025(NSMiscBlocks.PAPER_BLOCK);
        this.method_46025(NSMiscBlocks.BLOOMING_PAPER_BLOCK);
        this.method_46025(NSMiscBlocks.FRAMED_PAPER_BLOCK);
        this.method_46025(NSMiscBlocks.PAPER_SIGN);
        this.method_46025(NSMiscBlocks.PAPER_HANGING_SIGN);
        this.method_46025(NSMiscBlocks.PAPER_PANEL);
        this.method_46025(NSMiscBlocks.BLOOMING_PAPER_PANEL);
        this.method_46025(NSMiscBlocks.FRAMED_PAPER_PANEL);
        this.method_46025(NSMiscBlocks.RED_MOSS_BLOCK);
        this.method_46025(NSMiscBlocks.RED_MOSS_CARPET);
        this.method_46025(NSMiscBlocks.SANDY_SOIL);
        this.method_46025(NSMiscBlocks.ORNATE_SUCCULENT);
        this.method_46025(NSMiscBlocks.DROWSY_SUCCULENT);
        this.method_46025(NSMiscBlocks.AUREATE_SUCCULENT);
        this.method_46025(NSMiscBlocks.SAGE_SUCCULENT);
        this.method_46025(NSMiscBlocks.FOAMY_SUCCULENT);
        this.method_46025(NSMiscBlocks.IMPERIAL_SUCCULENT);
        this.method_46025(NSMiscBlocks.REGAL_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_ORNATE_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_DROWSY_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_AUREATE_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_SAGE_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_FOAMY_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_IMPERIAL_SUCCULENT);
        this.method_46023(NSMiscBlocks.POTTED_REGAL_SUCCULENT);
        this.method_46025(NSMiscBlocks.PINK_SAND);
        this.method_46025(NSMiscBlocks.PINK_SANDSTONE);
        this.method_45994(NSMiscBlocks.PINK_SANDSTONE_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSMiscBlocks.PINK_SANDSTONE_STAIRS);
        this.method_46025(NSMiscBlocks.PINK_SANDSTONE_WALL);
        this.method_46025(NSMiscBlocks.SMOOTH_PINK_SANDSTONE);
        this.method_45994(NSMiscBlocks.SMOOTH_PINK_SANDSTONE_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSMiscBlocks.SMOOTH_PINK_SANDSTONE_STAIRS);
        this.method_46025(NSMiscBlocks.CUT_PINK_SANDSTONE);
        this.method_45994(NSMiscBlocks.CUT_PINK_SANDSTONE_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSMiscBlocks.CHISELED_PINK_SANDSTONE);
        this.method_46025(NSColoredBlocks.KAOLIN);
        this.method_46025(NSColoredBlocks.WHITE_KAOLIN);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_KAOLIN);
        this.method_46025(NSColoredBlocks.GRAY_KAOLIN);
        this.method_46025(NSColoredBlocks.BLACK_KAOLIN);
        this.method_46025(NSColoredBlocks.BROWN_KAOLIN);
        this.method_46025(NSColoredBlocks.RED_KAOLIN);
        this.method_46025(NSColoredBlocks.ORANGE_KAOLIN);
        this.method_46025(NSColoredBlocks.YELLOW_KAOLIN);
        this.method_46025(NSColoredBlocks.LIME_KAOLIN);
        this.method_46025(NSColoredBlocks.GREEN_KAOLIN);
        this.method_46025(NSColoredBlocks.CYAN_KAOLIN);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_KAOLIN);
        this.method_46025(NSColoredBlocks.BLUE_KAOLIN);
        this.method_46025(NSColoredBlocks.PURPLE_KAOLIN);
        this.method_46025(NSColoredBlocks.MAGENTA_KAOLIN);
        this.method_46025(NSColoredBlocks.PINK_KAOLIN);
        this.method_45994(NSColoredBlocks.KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.WHITE_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_GRAY_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GRAY_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLACK_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BROWN_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.RED_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.ORANGE_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.YELLOW_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIME_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GREEN_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.CYAN_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_BLUE_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLUE_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PURPLE_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.MAGENTA_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PINK_KAOLIN_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSColoredBlocks.KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.WHITE_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.GRAY_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.BLACK_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.BROWN_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.RED_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.ORANGE_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.YELLOW_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.LIME_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.GREEN_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.CYAN_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.BLUE_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.PURPLE_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.MAGENTA_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.PINK_KAOLIN_STAIRS);
        this.method_46025(NSColoredBlocks.KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.WHITE_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.GRAY_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.BLACK_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.BROWN_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.RED_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.ORANGE_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.YELLOW_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.LIME_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.GREEN_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.CYAN_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.BLUE_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.PURPLE_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.MAGENTA_KAOLIN_BRICKS);
        this.method_46025(NSColoredBlocks.PINK_KAOLIN_BRICKS);
        this.method_45994(NSColoredBlocks.KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.WHITE_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GRAY_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLACK_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BROWN_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.RED_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.ORANGE_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.YELLOW_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIME_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GREEN_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.CYAN_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLUE_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PURPLE_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.MAGENTA_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PINK_KAOLIN_BRICK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSColoredBlocks.KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.WHITE_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.GRAY_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.BLACK_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.BROWN_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.RED_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.ORANGE_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.YELLOW_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.LIME_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.GREEN_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.CYAN_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.BLUE_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.PURPLE_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.MAGENTA_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.PINK_KAOLIN_BRICK_STAIRS);
        this.method_46025(NSColoredBlocks.PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.WHITE_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.GRAY_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.BLACK_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.BROWN_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.RED_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.ORANGE_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.YELLOW_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.LIME_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.GREEN_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.CYAN_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.BLUE_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.PURPLE_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.MAGENTA_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.PINK_PAPER_LANTERN);
        this.method_46025(NSColoredBlocks.WHITE_CHALK);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_CHALK);
        this.method_46025(NSColoredBlocks.GRAY_CHALK);
        this.method_46025(NSColoredBlocks.BLACK_CHALK);
        this.method_46025(NSColoredBlocks.BROWN_CHALK);
        this.method_46025(NSColoredBlocks.RED_CHALK);
        this.method_46025(NSColoredBlocks.ORANGE_CHALK);
        this.method_46025(NSColoredBlocks.YELLOW_CHALK);
        this.method_46025(NSColoredBlocks.LIME_CHALK);
        this.method_46025(NSColoredBlocks.GREEN_CHALK);
        this.method_46025(NSColoredBlocks.CYAN_CHALK);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_CHALK);
        this.method_46025(NSColoredBlocks.BLUE_CHALK);
        this.method_46025(NSColoredBlocks.PURPLE_CHALK);
        this.method_46025(NSColoredBlocks.MAGENTA_CHALK);
        this.method_46025(NSColoredBlocks.PINK_CHALK);
        this.method_45994(NSColoredBlocks.WHITE_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_GRAY_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GRAY_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLACK_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BROWN_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.RED_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.ORANGE_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.YELLOW_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIME_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.GREEN_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.CYAN_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.LIGHT_BLUE_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.BLUE_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PURPLE_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.MAGENTA_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_45994(NSColoredBlocks.PINK_CHALK_SLAB, arg_0 -> ((NSBlockLootTableProvider)this).method_45980(arg_0));
        this.method_46025(NSColoredBlocks.WHITE_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_GRAY_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.GRAY_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.BLACK_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.BROWN_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.RED_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.ORANGE_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.YELLOW_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.LIME_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.GREEN_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.CYAN_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.LIGHT_BLUE_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.BLUE_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.PURPLE_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.MAGENTA_CHALK_STAIRS);
        this.method_46025(NSColoredBlocks.PINK_CHALK_STAIRS);
        this.method_46025(NSMiscBlocks.DESERT_TURNIP_ROOT_BLOCK);
        this.method_46025(NSWoods.COCONUT_SPROUT);
        this.method_46025(NSWoods.COCONUT_BLOCK);
        this.method_45994(NSMiscBlocks.FRIGID_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.SCORCHED_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.BEACH_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.SEDGE_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.FLAXEN_FERN, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.OAT_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.LUSH_FERN, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.MELIC_GRASS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.RED_BEARBERRIES, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.RED_BITTER_SPROUTS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.GREEN_BEARBERRIES, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.GREEN_BITTER_SPROUTS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.PURPLE_BEARBERRIES, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45994(NSMiscBlocks.PURPLE_BITTER_SPROUTS, arg_0 -> ((NSBlockLootTableProvider)this).method_46017(arg_0));
        this.method_45988(NSMiscBlocks.TALL_FRIGID_GRASS, this.method_45985(NSMiscBlocks.TALL_FRIGID_GRASS, NSMiscBlocks.FRIGID_GRASS));
        this.method_45988(NSMiscBlocks.TALL_SCORCHED_GRASS, this.method_45985(NSMiscBlocks.TALL_SCORCHED_GRASS, NSMiscBlocks.SCORCHED_GRASS));
        this.method_45988(NSMiscBlocks.TALL_BEACH_GRASS, this.method_45985(NSMiscBlocks.TALL_BEACH_GRASS, NSMiscBlocks.BEACH_GRASS));
        this.method_45988(NSMiscBlocks.TALL_SEDGE_GRASS, this.method_45985(NSMiscBlocks.TALL_SEDGE_GRASS, NSMiscBlocks.SEDGE_GRASS));
        this.method_45988(NSMiscBlocks.LARGE_FLAXEN_FERN, this.method_45985(NSMiscBlocks.LARGE_FLAXEN_FERN, NSMiscBlocks.FLAXEN_FERN));
        this.method_45988(NSMiscBlocks.TALL_OAT_GRASS, this.method_45985(NSMiscBlocks.TALL_OAT_GRASS, NSMiscBlocks.OAT_GRASS));
        this.method_45988(NSMiscBlocks.LARGE_LUSH_FERN, this.method_45985(NSMiscBlocks.LARGE_LUSH_FERN, NSMiscBlocks.LUSH_FERN));
        this.method_45988(NSMiscBlocks.TALL_MELIC_GRASS, this.method_45985(NSMiscBlocks.TALL_MELIC_GRASS, NSMiscBlocks.MELIC_GRASS));
        this.method_46023(NSMiscBlocks.POTTED_PURPLE_BEARBERRIES);
        this.method_46023(NSMiscBlocks.POTTED_GREEN_BEARBERRIES);
        this.method_46023(NSMiscBlocks.POTTED_RED_BEARBERRIES);
        this.method_46023(NSMiscBlocks.POTTED_MELIC_GRASS);
        this.method_46023(NSMiscBlocks.POTTED_OAT_GRASS);
        this.method_46023(NSMiscBlocks.POTTED_LUSH_FERN);
        this.method_46023(NSMiscBlocks.POTTED_FLAXEN_FERN);
        this.method_46023(NSMiscBlocks.POTTED_SEDGE_GRASS);
        this.method_46023(NSMiscBlocks.POTTED_SCORCHED_GRASS);
        this.method_46023(NSMiscBlocks.POTTED_FRIGID_GRASS);
        this.method_46023(NSMiscBlocks.POTTED_BEACH_GRASS);
    }
}

